package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.entity.clone.PlayerTeam;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;

import org.lwjgl.opengl.GL11;


public class GuiCloneTeams extends GuiScreen {
	GuiScreen parentScreen;
	EntityClone clone;
	public GuiCloneTeams(EntityClone clone, GuiScreen parent){
		this.clone = clone;
		parentScreen = parent;
	}

	public void drawScreen(int par1, int par2, float par3) {
		drawDefaultBackground();
		drawRect(posXBox, posYBox, posXBox+buttonWidth-1, posYBox+buttonHeight-1, 0xffffffff);
		super.drawScreen(par1, par2, par3);
		renderTraitorBox();
	}
	
	private void renderTraitorBox() {
		mc.getTextureManager().bindTexture(icons);
		int i = Item.swordDiamond.itemID;
		int x = i % 16 * 16;
		int y = i / 16 * 16;
		drawTexturedModalRect(xTraitor+2, yTraitor+2, x, y, 16, 16);
		drawFlippedTexturedModalRect(xTraitor+buttonWidth-7-16, yTraitor+2, x, y, 16, 16);
	}

	private void drawFlippedTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
		float f = 0.00390625F;
        float f1 = 0.00390625F;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(par1 + 0, par2 + par6, zLevel, (float)(par3 + par5) * f, (float)(par4 + par6) * f1);
        tessellator.addVertexWithUV(par1 + par5, par2 + par6, zLevel, (float)(par3 + 0) * f, (float)(par4 + par6) * f1);
        tessellator.addVertexWithUV(par1 + par5, par2 + 0, zLevel, (float)(par3 + 0) * f, (float)(par4 + 0) * f1);
        tessellator.addVertexWithUV(par1 + 0, par2 + 0, zLevel, (float)(par3 + par5) * f, (float)(par4 + 0) * f1);
        tessellator.draw();
	}
	
	int selectedID = -1;

	public void setSelected(int teamID){
		int posX = teamID / maxDown * buttonWidth;
		int posY = teamID % maxDown * buttonHeight;
		posXBox = posX-2;
		posYBox = posY-2;
		selectedID = teamID;
	}

	protected void actionPerformed(GuiButton guibutton) {
		if(guibutton.id == 101){
			mc.displayGuiScreen(parentScreen);
		}else{
			changeSelected(guibutton);
		}
	}
	
	int xTraitor = 0, yTraitor = 0;
	
	int posXBox = 0;
	int posYBox = 0;
	int buttonWidth = 0;
	int buttonHeight = 0;
	int maxAcross = 0;
	int maxDown = 0;
	int max = 0;
	int position = 0;
	public void initGui() {
		buttonList.clear();
		buttonWidth = 155;
		buttonHeight = 25;
		maxAcross = width/buttonWidth;
		maxDown = height/buttonHeight;
		max = maxDown * maxAcross;
		PlayerTeam[] vals = PlayerTeam.values();
		for(int a = 0; a < vals.length; a++){
			if(clone.team.teamID == vals[a].teamID){
				setSelected(position);
			}
			addColouredButton(vals[a].name(), vals[a].teamColour, vals[a].teamID);
			if(vals[a].teamID == PlayerTeam.Traitor.teamID){
				xTraitor = (position-1) / maxDown * buttonWidth;
				yTraitor = (position-1) % maxDown * buttonHeight;
			}
		}
		
		int posX = (max-1) / maxDown * buttonWidth;
		int posY = (max-1) % maxDown * buttonHeight;
		buttonList.add(new GuiButton(101, posX, posY, 100, 20, "Done"));
	}
	
	public void addColouredButton(String text, int colour, int teamID){
		int posX = position / maxDown * buttonWidth;
		int posY = position % maxDown * buttonHeight;
		buttonList.add(new GuiColouredButton(position, posX, posY, buttonWidth-5, buttonHeight-5, text, colour, teamID));
		position++;
	}
	
	
	
	@Override
	public void updateScreen() {
		super.updateScreen();
		if(clone.team.teamID != selectedID){
			setSelected(clone.team.teamID);
		}
	}

	public void changeSelected(GuiButton button){
		if(button instanceof GuiColouredButton){
			GuiColouredButton button2 = (GuiColouredButton)button;
			setSelected(button2.id);
			clone.team = PlayerTeam.getByName(button2.displayString);
			clone.sendValueToServer(EntityClone.ID_TEAM);
		}
	}
	
	
	

}
